import GameKeys
from MyConfigConnector import MY_SingleConfigConnector

controller = GameLogic.getCurrentController()
owner = controller.owner

sButtonResume = controller.sensors["button1"].positive
sButtonOptions = controller.sensors["button2"].positive
sButtonSave = controller.sensors["button3"].positive
sButtonLoad = controller.sensors["button4"].positive
sEscape = controller.sensors["escape_game"]
#sEscape.key = GameKeys.ESCKEY
sButtonQuit = controller.sensors["button5"].positive

mouseClick = controller.sensors["mouse_accept"].positive
mouseMove = controller.sensors["mouse_move"].positive

sensor = controller.sensors["keyboard"]
keylist = sensor.events

selector = controller.actuators["selector_pos"]

optionsRot = controller.actuators["credits_rot"]
resumeRot = controller.actuators["start_rot"]
quitRot = controller.actuators["quit_rot"]
loadRot = controller.actuators["load_rot"]
saveRot = controller.actuators["save_rot"]

removeScene = controller.actuators["remove_scene"]
setScene = controller.actuators["set_scene"]
quitGame = controller.actuators["quit_game"]

select = owner["prop"]

accept = False

if mouseMove or mouseClick:
	if sButtonResume:
		select = 1
	elif sButtonOptions:
		select = 2
	elif sButtonSave:
		select = 3
	elif sButtonLoad:
		select = 4
	elif sButtonQuit:
		select = 5

for key in keylist:
	if key[1] == GameLogic.KX_INPUT_JUST_ACTIVATED:
		if key[0] == GameKeys.DOWNARROWKEY:
			select += 1
		elif key[0] == GameKeys.UPARROWKEY:
			select -= 1
		elif key[0] == GameKeys.RETKEY:
			accept = True

if select < 1:
	select = 1
elif select > 5:
	select = 5

if select == 1:
	controller.activate(resumeRot)
elif select == 2:
	controller.activate(optionsRot)
elif select == 3:
	controller.activate(saveRot)
elif select == 4:
	controller.activate(loadRot)
elif select == 5:
	controller.activate(quitRot)

if mouseClick or accept:
	if select == 1:
		removeScene.scene = "menu"
		controller.activate(removeScene)
		setScene.scene = "game"
		controller.activate(setScene)
	elif select == 2:
		removeScene.scene = "menu"
		controller.activate(removeScene)
		setScene.scene = "credits"
		controller.activate(setScene)
	elif select == 3:
		pass
	elif select == 4:
		if MY_SingleConfigConnector().getConfig():
			removeScene.scene = "menu"
			controller.activate(removeScene)
			setScene.scene = "game"
			controller.activate(setScene)
	elif select == 5:
		controller.activate(quitGame)

if sEscape.positive:
	controller.activate(quitGame)

owner["prop"] = select

controller.activate(selector)


