from time import clock
from math import sin, cos, pi, ceil, floor
from random import randint
from MyScene import MY_SingleScene
from MyGamePassiveParts import *
from MyGameUtils import SetPassivePartsConnection
import GameKeys
from MyGameTimer import MY_SingleTimer
from MyGameWorld import MY_SingleGameWorld
from MySpecialLists import MY_SingleIdList, MY_SingleElementList
from MyGameActiveHidden import MY_GameItem, MY_GameHurdle, MY_GameMerchItem
from MyControlKeys import MY_SingleControlKeys
from MyConfigConnector import MY_SingleConfigConnector
from Mathutils import Vector
import Rasterizer
import VideoTexture
from MyGamePassiveParts import MY_GamePlatform, MY_GameStair

#####################
### init the game ###
#####################

Rasterizer.showMouse(0)

window_width = Rasterizer.getWindowWidth()
window_height = Rasterizer.getWindowHeight()

OUTSIDE = 0
INSIDE = 1
INTERSECT = 2

DEAD = False

myScene = MY_SingleScene()
myWorld = MY_SingleGameWorld()
myElementList = MY_SingleElementList()
myControlKeys = MY_SingleControlKeys()

scene = GameLogic.getCurrentScene()
center = scene.objects["OBcenter"]
spawnPoint = scene.objects["OBspawn_point"]
switchBox = scene.objects["OBswitch_case"]
feedback = scene.objects["OBfeedback"]

controller = GameLogic.getCurrentController()
owner = controller.owner

### init game timer
myTimer = MY_SingleTimer()
myTimer.setCurrentTime(scene)
timer_now = myTimer.NOW
timer_ago = myTimer.AGO
dtime = timer_now - timer_ago # dt = time passed to this frame

### init sounds
bgSound = controller.actuators["bg_sound"]
#controller.activate(bgSound)


### init game objects
myCharacter = myScene["character"]

if MY_SingleConfigConnector().loaded:
	myCharacter.inventoryList.fillWithConfigValues()
	myCharacter.setInventoryGauge()
	MY_SingleConfigConnector().loaded = False

myFirstPersonCamera = myScene["fpc"]

myThirdPersonCamera = myScene["tpc"]

#myBackSightCamera = myScene["bsc"]
#myBackSightCamera.gObject.setViewport(window_width*5/8, window_height*4/6, window_width*7/8, window_height*5/6)
#myBackSightCamera.gObject.useViewport = True

skySphere = myScene["sky_sphere"]
skySphere.setAction(myWorld.gravityAxis, myCharacter.getPosition())	# sky sphere rotation around character position (driven by gravity axis)
sky_radius = skySphere.gObject.worldScale[0]


### init lights
skyLampXY = myScene["sky_lamp_xy"]
skyLampXY.setRotation("xy", sky_radius-20, myCharacter.getPosition())

skyLampXZ = myScene["sky_lamp_xz"]
skyLampXZ.setRotation("xz", -(sky_radius-20), myCharacter.getPosition())

skyLampYZ = myScene["sky_lamp_yz"]
skyLampYZ.setRotation("yz", sky_radius-20, myCharacter.getPosition())

if not myWorld.isPaused:
	for light in myScene.objectsLight:
		max_amount = 0.7
		fade_duration = 3
		if (light.gObject.energy != max_amount):
			light.setEnergyFade(max_amount, fade_duration)
else:
	for light in myScene.objectsLight:
		light.fadeStart = myTimer.NOW

myHurdleTimer = myScene["timer"]
myStartText = myScene["osd"]

### init visor
mirrorVisor = scene.objects["OBvisor"]


### init sensors

sRun = controller.sensors["run"]
sRun.key = GameKeys.LEFTCTRLKEY

sVisor = controller.sensors["visor"]
sVisor.key = GameKeys.VKEY

sRearView = controller.sensors["rear"]
sRearView.key = GameKeys.TKEY

sTpcView = controller.sensors["tpc"]

# item keys
sNewPlatform = controller.sensors["newplatf"]
sNewPlatform.key = GameKeys.ONEKEY

sPower = controller.sensors["power"]
sPower.key = GameKeys.TWOKEY

sAmmo = controller.sensors["reload"]
sAmmo.key = GameKeys.THREEKEY

sOneighty = controller.sensors["oneighty"]
sOneighty.key = GameKeys.FOURKEY

sLowGrav = controller.sensors["low_grav"]
sLowGrav.key = GameKeys.FIVEKEY

sHighGrav = controller.sensors["high_grav"]
sHighGrav.key = GameKeys.SIXKEY

sDelayView = controller.sensors["delay_view"]
sDelayView.key = GameKeys.SEVENKEY

sTransWarp = controller.sensors["transwarp"]
sTransWarp.key = GameKeys.EIGHTKEY

# game keys
sStart = controller.sensors["start"]
sStart.key = GameKeys.RETKEY
	
sInfo = controller.sensors["info"]
sUpper= controller.sensors["upper"]
#sUpper.key = GameKeys.ESCKEY

sPause = controller.sensors["pause"]
sPause.key = GameKeys.PKEY

sSound = controller.sensors["sound"]
sSound.key = GameKeys.MKEY

sKeys = controller.sensors["special_keys"]
sKeys.key = GameKeys.KKEY

sUnusual = controller.sensors["unusual"]

# mouse sensor
sMouse = controller.sensors["mouse"]
sShot = controller.sensors["shot"]
sAim = controller.sensors["aim"]
sChangeWeapon = controller.sensors["change_weapon"]

# ground collision
sGroundFront = controller.sensors["ground_f"]
gfront = sGroundFront.positive
sGroundBack = controller.sensors["ground_b"]
gback = sGroundBack.positive
sGroundLeft = controller.sensors["ground_l"]
gleft = sGroundLeft.positive
sGroundRight = controller.sensors["ground_r"]
gright = sGroundRight.positive

ground_collision = [gfront, gback, gleft, gright]

# side collision
sSideFront = controller.sensors["side_f"]
sfront = sSideFront.positive
sSideBack = controller.sensors["side_b"]
sback = sSideBack.positive
sSideLeft = controller.sensors["side_l"]
sleft = sSideLeft.positive
sSideRight = controller.sensors["side_r"]
sright = sSideRight.positive

side_collision = [sfront, sback, sleft, sright]

# touch sensor
sTouch = controller.sensors["touch_btm"]
sTouchStair = controller.sensors["touch_stair"]
sTouchGround = controller.sensors["touch_ground"]


### init actuators
suspendScene = controller.actuators["suspend"]
overlayScene = controller.actuators["overlay"]

walkIpo = controller.actuators["walk"]
crouchIpo = controller.actuators["crouch"]
notCrouchIpo = controller.actuators["no_crouch"]
canonWalkIpo = controller.actuators["canon_walk"]
canonAim = controller.actuators["canon_aim"]
canonNotAim = controller.actuators["canon_notaim"]
sniperAim = controller.actuators["sniper_aim"]
sniperNotAim = controller.actuators["sniper_notaim"]
visorDown = controller.actuators["visor_down"]
visorUp = controller.actuators["visor_up"]
backStroke = controller.actuators["backstroke"]
hurtVisible = controller.actuators["purple_hit"]
switchVisible = controller.actuators["switch_visible"]
switchBoxUp = controller.actuators["switch_box_up"]
switchOn = controller.actuators["switch_on"]

### init mouse and keyboard input
mouse_x = (window_width / 2) - sMouse.position[0]
mouse_y = (window_height / 2) - sMouse.position[1]

mouse_position = [mouse_x, mouse_y]

if hasattr(GameLogic, "init") == False:
	mouse_position = [0, 0]
	GameLogic.init = True
	
if not myControlKeys.init:
	myControlKeys.initControlKeys(controller)
	myControlKeys.setControlKeysEffect()

### init game parameters
pop_duration = 1000
warp_time = 10
platf_rotated = 2
next_item_time = 1
next_hurdle_time = 10

power = 0
ammo = 0
oneighty = 0
low_grav = 0
high_grav = 0
delay_view = 0
transwarp = 0
turn_duration = 2000
stair_collision = False
step_height = 0
platform_collision_up = False
collision_side = "none"
hit_plane = 0
hit_direction = "none"
mario_jump = False

### sensor queries
"""
if sRearView.positive:
	myThirdPersonCamera.gObject.setOnTop()
else:
	myFirstPersonCamera.gObject.setOnTop()
"""
if sStart.positive and myWorld.isPaused and not myWorld.boxIntro and myStartText.gObject.visible:	# after 5 seconds ?
	controller.activate(switchOn)
	myStartText.setVisible(False)

if sKeys.positive:
	if myWorld.specialKeys:
		myWorld.specialKeys = False
		myControlKeys.setControlKeysEffect()
	else:
		myWorld.specialKeys = True
		myControlKeys.setControlKeysEffect(myCharacter.worldPlane, myCharacter.oppositePlane)

if sTpcView.positive:
	if myWorld.tpcOn:
		myFirstPersonCamera.gObject.setOnTop()
		myWorld.tpcOn = False
	else:
		myThirdPersonCamera.gObject.setOnTop()
		myWorld.tpcOn = True

if switchBox["ipo_frame"] >= switchOn.frameEnd:
	myWorld.isPaused = False
	myWorld.switchOn = True
	controller.activate(switchVisible)

if sInfo.positive and not myWorld.isPaused:
	suspendScene.scene = "game"
	controller.activate(suspendScene)
	overlayScene.scene = "inventory"
	controller.activate(overlayScene)

if sPause.positive or sUpper.positive:
	bgSound.volume = 0
	myWorld.isPaused = True
	suspendScene.scene = "game"
	controller.activate(suspendScene)
	overlayScene.scene = "pause"
	controller.activate(overlayScene)

if sChangeWeapon.positive:
	if myCharacter.useSuperGun:
		print "use canon"
		color = str(myCharacter.ammo)
		mag_color = controller.actuators[color]
		controller.activate(mag_color)
		myCharacter.useSuperGun = False
	else:
		if myCharacter.superGun:
			print "use sniper"
			superGun = controller.actuators["sniper"]
			controller.activate(superGun)
			sShot.tap = False
			myCharacter.useSuperGun = True

power_no = scene.objects["OBpower_no"]	
ammo_no = scene.objects["OBammo_no"]
oneighty_no = scene.objects["OBoneighty_no"]
newplatf_no = scene.objects["OBnewplatf_no"]
low_grav_no = scene.objects["OBlow_grav_no"]	
high_grav_no = scene.objects["OBhigh_grav_no"]
delay_view_no = scene.objects["OBdelay_view_no"]
transwarp_no = scene.objects["OBtranswarp_no"]	

### checks if its ok to spawn a new platform for flying player
fly_mode = True
if myTimer.NOW - myCharacter.flyTime >= 3:
	pass
else:
	for i in myScene.objectsPassive:
	
		if i.deleteDelay < 0:
			fly_mode = False
			break

if fly_mode and not myWorld.switchOn:
	myWorld.restartGame = True
	DEAD = True

shoot = False
if myTimer.NOW - myCharacter.shotTime >= myCharacter.shotInterval:
	shoot = True

if sShot.positive and shoot:#myCharacter.shotTime <= 0:
	if not myCharacter.useSuperGun:
		if myCharacter.ammo > 0:
			controller.activate(backStroke)
			bullet_spawn = scene.objects["OBbullet_spawn"]
			myCharacter.ammo -= 1
			color = str(myCharacter.ammo)
			mag_color = controller.actuators[color]
			controller.activate(mag_color)
			bulletObject = scene.addObject(scene.objectsInactive["OBbullet"], bullet_spawn, 300)
			myCharacter.shotTime = myTimer.NOW
			myCharacter.shotInterval = 1
			bulletObject.setLinearVelocity([0, 25, 1], 1)
			bulletObject.localOrientation = bullet_spawn.worldOrientation
	else:
		controller.activate(backStroke)
		bullet_spawn = scene.objects["OBbullet_spawn"]
		bulletObject = scene.addObject(scene.objectsInactive["OBprojectile"], bullet_spawn, 180)
		myCharacter.shotTime = myTimer.NOW
		myCharacter.shotInterval = 0.1
		bulletObject.setLinearVelocity([0, 60, 1], 1)
		bulletObject.localOrientation = bullet_spawn.worldOrientation

if myCharacter.getItemLifeTime("power"):
	power = 4
	if sPower.positive:
		myWorld.setFeedBack(controller, "no_action")
elif sPower.positive:
	if power_no.visible:
		myWorld.setFeedBack(controller, "no_action")
		
	if myCharacter.setInventoryItem("power", False):
		myWorld.setFeedBack(controller, "power", True)

	power_no.visible = True
else:
	power_no.visible = False

if myCharacter.useSuperGun:
	ammo_no.visible = True
	
	if sAmmo.positive:
		myWorld.setFeedBack(controller, "no_action")
elif myCharacter.ammo == 0:
	if sAmmo.positive:
		if ammo_no.visible:
			myWorld.setFeedBack(controller, "no_action")
			
		if myCharacter.setInventoryItem("ammo", False):
			myCharacter.reloadAmmo()
			color = str(myCharacter.ammo)
			mag_color = controller.actuators[color]
			controller.activate(mag_color)
		
			myWorld.setFeedBack(controller, "ammo", True)
else:
	ammo_no.visible = False

if myCharacter.groundObject != None and myCharacter.groundObject.name != "platform" and not myCharacter.groundObject.gObject.invalid:
	distance_to_ground = (myCharacter.getPosition() - myCharacter.groundObject.midPoint).length
	if distance_to_ground <= (myCharacter.groundObject.gObject.worldScale[1] * myCharacter.groundObject.gObject["depth"]) / 2.0:
		if sOneighty.positive and not myCharacter.wallTurn:
			if oneighty_no.visible:
				myWorld.setFeedBack(controller, "no_action")
			
			if myCharacter.setInventoryItem("oneighty", False):
				myCharacter.initOneighty(turn_duration)
				myWorld.setFeedBack(controller, "oneighty", True)
		elif myCharacter.wallTurn:
			oneighty_no.visible = True
		else:
			oneighty_no.visible = False
	else:
		if sOneighty.positive:
			myWorld.setFeedBack(controller, "no_action")
		oneighty_no.visible = True
else:
	oneighty_no.visible = True

if myWorld.switchOn:
	if sNewPlatform.positive:
		if ground_collision == [0, 0, 0, 0]:
			if newplatf_no.visible:
				myWorld.setFeedBack(controller, "no_action")
		
			if myCharacter.setInventoryItem("newplatf", False):
		
				myWorld.setFeedBack(controller, "newplatf", True)

				while myScene.objectsPassive != []:
					myScene.objectsPassive[0].deleteObject(True, False)

				dist_to_me = 3
				spawn_pos = Vector(myWorld.gravityVector * dist_to_me) + Vector(myCharacter.getPosition())

				if myWorld.gravityVector[0] != 0:
					cur_plane = 2
				elif myWorld.gravityVector[1] != 0:
					cur_plane = 1
				elif myWorld.gravityVector[2] != 0:
					cur_plane = 0

				newElement = MY_GamePlatform(scene)
				newElement.setElement([0, spawn_pos], cur_plane, platf_rotated, 1)
				newElement.pop(False)
		
				myCharacter.groundObject = newElement
		
				myCharacter.flyTime = myTimer.NOW
		else:
			myWorld.setFeedBack(controller, "no_action")
	else:
		newplatf_no.visible = False
else:
	if sNewPlatform.positive:
		myWorld.setFeedBack(controller, "no_action")
	newplatf_no.visible = True

for i in myCharacter.inventoryList.inventoryList:
	if i[0] == 0:
		if i[1] == "power": power_no.visible = True
		elif i[1] == "ammo": ammo_no.visible = True
		elif i[1] == "newplatf": newplatf_no.visible = True
		elif i[1] == "oneighty": oneighty_no.visible = True
		elif i[1] == "low_grav": low_grav_no.visible = True
		elif i[1] == "high_grav": high_grav_no.visible = True
		elif i[1] == "delay_view": delay_view_no.visible = True
		elif i[1] == "transwarp": transwarp_no.visible = True

if sLowGrav.positive:
	if low_grav_no.visible:
		myWorld.setFeedBack(controller, "no_action")
	else:
		myCharacter.setInventoryItem("low_grav", False)
	
if sHighGrav.positive:
	if high_grav_no.visible:
		myWorld.setFeedBack(controller, "no_action")
	else:
		myCharacter.setInventoryItem("high_grav", False)
	
if sDelayView.positive:
	if delay_view_no.visible:
		myWorld.setFeedBack(controller, "no_action")
	else:
		myCharacter.setInventoryItem("delay_view", False)
	
if sTransWarp.positive:
	if transwarp_no.visible:
		myWorld.setFeedBack(controller, "no_action")
	else:
		myCharacter.setInventoryItem("transwarp", False)

if sAim.positive and not myCharacter.aim:
	myCharacter.aim = True
	"""
	if myCharacter.superGun:
		controller.activate(sniperAim)
	else:
	"""
	controller.activate(canonAim)
elif not sAim.positive and myCharacter.aim:
	myCharacter.aim = False
	"""
	if myCharacter.superGun:
		controller.activate(sniperNotAim)
	else:
	"""
	controller.activate(canonNotAim)

if sTouch.positive:
	hitObject = sTouch.hitObject
	if hitObject.name[2:] == "delegate_item":
		print "get item"
		itemObject = myScene.getMyActiveTempObjectById(hitObject["id"])
		itemObject.deleteObject()
		myWorld.setFeedBack(controller, "add_skill_icon")
		if hitObject.meshes[0].name[7:] == "sniper":
			if not myCharacter.superGun:
				sniper = controller.actuators["sniper"]
				controller.activate(sniper)
				myCharacter.superGun = True
				myCharacter.useSuperGun = True
				sShot.tap = False
		myCharacter.setInventoryItem(hitObject.meshes[0].name[7:], True)
	elif hitObject.name[2:7] == "xItem":
		myCharacter.setMerchItem(hitObject.name[8:])
		print "extra item"
		# dirty code because of this strange linked object behaviour
		for idx, obj in enumerate(myScene.objectsMerch):
			if obj.gObject == hitObject:# or obj.gObjectTwo == hitObject:
				obj.deleteObject()
				break
		myWorld.setFeedBack(controller, "collect_icon")
	elif hitObject.name[2:8] == "hurdle" and not myCharacter.godMode:
		hurtVisible.visibility = True
		controller.activate(hurtVisible)
		controller.deactivate(hurtVisible)
		print "hurdle hit"
		if not myCharacter.setInventoryItem("health", False):
			DEAD = True
		else:
			mario_jump = True
		
			myCharacter.marioJump(Vector(hitObject.worldPosition))
			myCharacter.godMode = True
			myCharacter.godStartTime = myTimer.NOW

if sTouchGround.positive:
	hitObject = sTouchGround.hitObject
	if hitObject.name[2:] == "delegate_item":
		print "get item"
		itemObject = myScene.getMyActiveTempObjectById(hitObject["id"])
		itemObject.deleteObject()
		myWorld.setFeedBack(controller, "add_skill_icon")
		if hitObject.meshes[0].name[7:] == "sniper":
			if not myCharacter.superGun:
				sniper = controller.actuators["sniper"]
				controller.activate(sniper)
				myCharacter.superGun = True
				sShot.tap = True
		myCharacter.setInventoryItem(hitObject.meshes[0].name[7:], True)
	elif hitObject.name[2:7] == "xItem":
		myCharacter.setMerchItem(hitObject.name[8:])
		print "extra item"
		"""
		merchObject = myScene.getMyActiveTempObjectById(hitObject["id"])
		merchObject.deleteObject
		"""
		# dirty code because of this strange linked object behaviour
		for obj in myScene.objectsMerch:
			if obj.gObject == hitObject:# or obj.gObjectTwo == hitObject:
				obj.deleteObject()
				break
		myWorld.setFeedBack(controller, "collect_icon")
	elif hitObject.name[2:8] == "hurdle":
		hurdleObject = myScene.getMyActiveTempObjectById(hitObject["id"])
		print "hurdle hit on head"
		merchObject = MY_GameMerchItem(scene, hurdleObject.gObject)
		hurdleObject.deleteObject()
	elif hitObject.has_key("depth"):		
		# sets ground object of player to set it as root object, so hurdle knows where to go
		my_hit_object = myScene.getMyPassiveObjectById(hitObject["id"])
		if myCharacter.groundObject != my_hit_object:
			print "change platform"
			myCharacter.groundObject = my_hit_object
			SetReverseRootConnection(my_hit_object)
			my_hit_object.rootConnectObject = None

if myTimer.NOW - myCharacter.visorAnimStart >= visorDown.frameEnd / 60:
	myCharacter.visorAnimStart = 0

if sVisor.positive and not myCharacter.hasVisor and myCharacter.visorAnimStart == 0:
	controller.activate(visorDown)
	myCharacter.hasVisor = True
	myCharacter.visorAnimStart = myTimer.NOW
if sVisor.positive and myCharacter.hasVisor and myCharacter.visorAnimStart == 0:
	controller.activate(visorUp)
	myCharacter.hasVisor = False
	myCharacter.visorAnimStart = myTimer.NOW

# sets the mirror to show players back view
if mirrorVisor.has_key("Mirror") == True:
	mirrorVisor["Mirror"].refresh(True)
else:
	if mirrorVisor.has_key("cam") == True:
		objList = scene.objects
		camName = mirrorVisor["cam"]
		cam = objList["OB" + camName]
		
	else:  
		cam = scene.cameras["OBbsc"]

	matID = VideoTexture.materialID(mirrorVisor, "MA" + mirrorVisor['material'])

	if mirrorVisor.has_key('channel') == True:
		texChannel = mirrorVisor['channel']
	else:
		texChannel = 0

	mirror = VideoTexture.Texture(mirrorVisor, matID, texChannel)
	mirror.source = VideoTexture.ImageRender(scene,cam)
	mirrorVisor["Mirror"] = mirror

if sUnusual.positive:
	if not myWorld.isUnusual:
		myWorld.isUnusual = True
		myCharacter.godStartTime = 0
		myCharacter.godMode = True
		myCharacter.setInventoryGauge()
		MY_SingleScene().scene.objects["OBhurdle_alert"].visible = False
		myHurdleTimer.setVisible(False)
		temp_list = []
		for i in myScene.objectsActiveTemp:
			if i.name == "delegate_item":# or i.name == "hurdle":
				temp_list.append(i)
				#i.deleteObject()
		for i in temp_list:
			i.deleteObject()

		scene.objects["OBstab"].setVisible(True, True)
		scene.objects["OBcanon_walk_anim"].setVisible(False, True)
	else:
		myWorld.isUnusual = False
		myCharacter.godStartTime = myTimer.NOW
		myCharacter.godMode = True
		myCharacter.setInventoryGauge()
		MY_SingleScene().scene.objects["OBhurdle_alert"].visible = True
		myHurdleTimer.setVisible(True)
		scene.objects["OBstab"].setVisible(False, True)
		scene.objects["OBcanon_walk_anim"].setVisible(True, True)

########################
### begin game logic ###
########################

if feedback["show_feedback"] and myTimer.NOW - feedback["timer"] > 2:
	feedback["show_feedback"] = False
	for obj in feedback.children:
		obj.visible = False

### sets new platforms and stairs
if not myWorld.isPaused:
	
	if sSound.positive:
		if feedback["show_feedback"]:
			for obj in feedback.children:
				obj.visible = False

		if bgSound.volume > 0:
			feedback.children["OBsound_off"].visible = True
			bgSound.volume = 0
			myWorld.soundOn = False
			print "sound off"
		else:
			feedback.children["OBsound_on"].visible = True
			bgSound.volume = 1
			myWorld.soundOn = True
			print "sound on"

		feedback["show_feedback"] = True
		feedback["timer"] = myTimer.NOW
	
	if myWorld.soundOn:
		bgSound.volume = 1
	
	myStartText.setVisible(False)
	
	if floor(myTimer.NOW) != floor(myTimer.AGO):
		#print "----------------BEGIN MAIN----------------"
		if myCharacter.useSuperGun:
			if not myCharacter.setInventoryItem("sniper", False):
				print "sniper off"
				myCharacter.superGun = False
				myCharacter.useSuperGun = False
				color = str(myCharacter.ammo)
				mag_color = controller.actuators[color]
				controller.activate(mag_color)
				myCharacter.setInventoryGauge()
		
		if MY_SingleScene().scene.objects["OBhurdle_alert"].visible:
			myHurdleTimer.theText -= 1
			myHurdleTimer.setText()
			if myHurdleTimer.theText <= 0:
				myWorld.nextHurdle = True
				myHurdleTimer.theText = warp_time
		
		if feedback["show_feedback"] and feedback["timer"] > 0:
			feedback["timer"] -= 1
		else:
			feedback["show_feedback"] = False
			for obj in feedback.children:
				obj.visible = False

		# build new game elements
		freeIds = MY_SingleIdList()
		build_object = False
		newObj = None
		newElement = None
		side = []
		
		if not myCharacter.groundObject.gObject.invalid:
			myGroundObject = myCharacter.groundObject
			ground_object_freesides_list = myGroundObject.getChildren()
			ground_object_freesides_list.insert(0,myGroundObject)
		
			# prefer free sides near the player's ground object
			for obj in ground_object_freesides_list:
				free_sides = obj.getFreeSidesPositions()
				for side in free_sides:
					connection_point = side[1]
					if myThirdPersonCamera.pointInsideFrustum(connection_point) and freeIds.idList != []:
						newObj = obj
						build_object = True
						break
			
				if build_object:
					break					
		
		if not build_object:
			temp_passive_list = myScene.objectsPassive[:]
			for obj in temp_passive_list:
				free_sides = obj.getFreeSidesPositions()
				for side in free_sides:
					connection_point = side[1]
					if myThirdPersonCamera.pointInsideFrustum(connection_point) and freeIds.idList != []:
						newObj = obj
						build_object = True
						break
				if build_object:
					break
		
		if build_object:		
			connected_side = side[0]
			if newObj.name != "platform":
				newElement = MY_GamePlatform(scene)
				if newObj.name == "single_step":
					platf_rotated = randint(0, 2)
					#platf_rotated = 1
				newElement.setElement(side, newObj.worldPlane, platf_rotated)
				newElement.initPop(2, timer_now, pop_duration)
			else:
				stair = randint(0,1)
				name = "stair"
				scaling = 1
				if not stair:
					name = "single_step"
					scaling = randint(5, 10)
	
				newElement = MY_GameStair(scene, name, scaling)
				newElement.setElement(side, newObj.worldPlane)
				newElement.initPop(2, timer_now, pop_duration)
	
			if not newObj.alive:
				newElement.setAlive(False)

			SetPassivePartsConnection(connected_side, newObj, newElement)

	### sets active game elements (hurdles and items)
	if not myWorld.isUnusual:
		for obj in myScene.objectsPassive:
			done = 0
			# sets items on platforms 
			if myTimer.NOW >= myWorld.nextItemTime and obj.name == "platform" and not obj.hasItem:
				dist_vector = myCharacter.getPosition() - obj.getPosition()
				distance = dist_vector.length
			
				do_spawn = True
			
				if obj.curPopStep != obj.popSteps or obj.hurdleObject != None:
					do_spawn = False
			
				if distance >= 10 and do_spawn:
					print "set item"
					newItem = MY_GameItem(scene, "delegate_item", obj)
					newItem.lifeTime = 10
					newItem.rotationStart = myTimer.NOW
					myWorld.nextItemTime = floor(myTimer.NOW) + next_item_time
					done += 1
	
			# sets hurdles on stair objects
			if myWorld.nextHurdle and obj.name != "platform" and obj.worldPlane == myCharacter.worldPlane and obj != myCharacter.groundObject:# and myWorld.numberOfHurdle <= 3:
				dist_vector = myCharacter.getPosition() - obj.midPoint
				distance = dist_vector.length

				if distance <= 50 and distance >= 5:
					print "set hurdle"
					delta = -obj.gObject["height"] * myWorld.gravityVector
	
					if obj.name != "stair":
						delta *= 5
					spawnPoint.worldPosition = obj.midPoint + delta
					newHurdle = MY_GameHurdle(scene, "hurdle", spawnPoint)
					newHurdle.groundObject = obj
					obj.hurdleObject = newHurdle
					myWorld.numberOfHurdle += 1
					myWorld.nextHurdle = False
					done += 1

			if done >= 2:
				break
		
		### sets actions for hurdle and items
		delete_temp_active_objects = []
		for i in myScene.objectsActiveTemp:
			# hurdle movement
			if i.name == "hurdle":
				if not myCharacter.wallTurn:
					i.setOrientation(myCharacter.getPosition())
					i.worldPlane = myCharacter.worldPlane
				
					prota_pos = myCharacter.getPosition()
				
					issue = i.setHurdle(prota_pos)
				
					if issue == "bullet":
						merchObject = MY_GameMerchItem(scene, i.gObject)
						merchObject.lifeTime = 10
						delete_temp_active_objects.append(i)
						#i.deleteObject()
						myWorld.numberOfHurdle -= 1
				else:
					i.setLinearVelocity(Vector([0,0,0]))
			
				if not i.getAlive(myCharacter.getPosition()):
					print "hurdle out"
					#i.deleteObject()
					delete_temp_active_objects.append(i)
					myWorld.numberOfHurdle -= 1
	
			# item movement
			elif i.name == "delegate_item":
				i.setRotation()
		
				if not i.getAlive(myCharacter.getPosition()):
					print "kill item"
					delete_temp_active_objects.append(i)
					#i.deleteObject()

		# extra loop because of the double object thing with linked objects
		for i in myScene.objectsMerch:
			if not i.getAlive(myCharacter.getPosition()):
				print "kill extra item"
				delete_temp_active_objects.append(i)
				#i.deleteObject(scene)

		for i in delete_temp_active_objects:
			i.deleteObject()
else:
	if switchBox["ipo_frame"] < switchBoxUp.frameEnd and myFirstPersonCamera.pointInsideFrustum(switchBox.worldPosition) and myWorld.boxIntro:
		controller.activate(switchBoxUp)
	elif switchBox["ipo_frame"] >= switchBoxUp.frameEnd:
		controller.deactivate(switchBoxUp)
		myWorld.boxIntro = False
	
	if not myWorld.boxIntro and myFirstPersonCamera.pointInsideFrustum(Vector(switchBox.worldPosition) + Vector([0,0,3])):	
		myStartText.setVisible(True)
	else:
		 myStartText.setVisible(False)

for obj in myScene.objectsPassive:
	# sets popping for object spawn
	if obj.popSteps != 0 and obj != myCharacter.groundObject and obj.hurdleObject == None:
		obj.pop(True)
	elif obj == myCharacter.groundObject or obj.hurdleObject != None:
		obj.pop(False)
		obj.popSteps = 0
	else:
		obj.pop(False)

	# initiate object deletion if outside rendering area and some limitation
	if myThirdPersonCamera.boxInsideFrustum(obj.boundingBox) == OUTSIDE:
		obj.setAlive(False)
	else:
		obj.setAlive(True)

### search for objects to delete with their possible items
for obj in myScene.objectsPassive:
	
	if not obj.alive:
		obj.deleteObject()

### character movement
if side_collision != [0, 0, 0, 0]:

	if sfront:
		collision_side = "front"
		hit_object = sSideFront.hitObject
	elif sback:
		collision_side = "back"
		hit_object = sSideBack.hitObject
	elif sleft:
		collision_side = "left"
		hit_object = sSideLeft.hitObject
	elif sright:
		collision_side = "right"
		hit_object = sSideRight.hitObject

	if hit_object.name[2:7] == "stair":
		stair_collision = True
		step_height = hit_object["step_height"]
	elif hit_object.name[2:10] == "platform":
		myHitObject = myScene.getMyPassiveObjectById(hit_object["id"])
		
		if myHitObject.isRotated != 2:
			platform_collision_up = True
			hit_plane = myHitObject.worldPlane
			hit_direction = GetGlobalOrientationToMe(myCharacter, myHitObject)

if platform_collision_up and not myCharacter.wallTurn:
	myCharacter.initWallRun(hit_direction, hit_plane, turn_duration)
	print "hit direction: ",
	print hit_direction
	print "hit plane: ",
	print hit_plane

look_sensitivity = 0.10

myCharacter.look(mouse_position, dtime, look_sensitivity)

if myCharacter.godMode and (myTimer.NOW - myCharacter.godStartTime) >= 2:
	myCharacter.godMode = False
	hurtVisible.visibility = False
	controller.activate(hurtVisible)
	controller.deactivate(hurtVisible)

stair_touched = sTouchStair.positive

if ground_collision != [0, 0, 0, 0] and not myCharacter.wallTurn and not mario_jump:
	myCharacter.flyTime = myTimer.NOW
	
	move_fwd = myControlKeys.FWD.positive
	move_back = myControlKeys.BWD.positive
	move_left = myControlKeys.SNL.positive
	move_right = myControlKeys.DXR.positive
	
	jump = myControlKeys.UWD.positive
	crouch = myControlKeys.DWD.positive
	
	if crouch and not myCharacter.isCrouching:
		controller.activate(crouchIpo)
		myCharacter.isCrouching = True
	elif not crouch and myCharacter.isCrouching:
		controller.activate(notCrouchIpo)
		myCharacter.isCrouching = False
		
	move_speed = myCharacter.getLinearVelocity(1)
	
	if not myCharacter.isJumping:
		if stair_touched:
			move_force = 6
		else:
			move_force = 6 + power + (sRun.positive * 4)
		move_speed = myCharacter.move(move_fwd, move_back, move_left, move_right, move_force)
	
	myCharacter.stepUp = False
	if stair_touched and [move_speed[0], move_speed[1]] != [0, 0]:
		print "stair"
		jump_force = 8
		myCharacter.jump(move_speed, jump_force)
		myCharacter.stepUp = True
		myCharacter.stepDown = 6 #step_down_amount
		
	if not myCharacter.isJumping and jump:
		jump_force = 10 + power
		myCharacter.jump(move_speed, jump_force)
	
	if not jump:
		myCharacter.isJumping = False
	
	if move_speed != [0, 0, 0]:
		
		if not myCharacter.isJumping:
			controller.activate(walkIpo)
			controller.activate(canonWalkIpo)
			stab = controller.actuators["stab_walk"]
			controller.activate(stab)
		else:
			controller.deactivate(walkIpo)
			controller.deactivate(canonWalkIpo)
		
		myCharacter.setLinearVelocity(move_speed, 1)

else:
	if myTimer.NOW - myCharacter.flyTime >= 5:
		myCharacter.flyTime = myTimer.NOW
		
		hurtVisible.visibility = True
		controller.activate(hurtVisible)
		controller.deactivate(hurtVisible)
		myCharacter.godMode = True
		myCharacter.godStartTime = myTimer.NOW
		
		if not myCharacter.setInventoryItem("health", False):
			DEAD = True
	
	if myCharacter.wallTurn:
		myCharacter.flyTime = myTimer.NOW
	
	if myCharacter.stepDown > 0 and myCharacter.stepUp:
		
		if stair_touched:
			pass
		else:
			#print "sub"
			#print myCharacter.stepDown
			move_speed = myCharacter.getLinearVelocity(1)
			#move_speed[2] -= 0.2
			jump_force = -1
			myCharacter.jump(move_speed, jump_force)
			myCharacter.stepDown -= 1
			myCharacter.setLinearVelocity(move_speed, 1)

if DEAD:
	suspendScene.scene = "game"
	controller.activate(suspendScene)
	overlayScene.scene = "game_over"
	controller.activate(overlayScene)

myTimer.setPassedTime(scene)

Rasterizer.setMousePosition(window_width/2, window_height/2)


