from math import floor
import Rasterizer
from Mathutils import Vector, RotationMatrix
from MyConfigConnector import MY_SingleConfigConnector
from MyGameWorld import MY_SingleGameWorld
from MySpecialLists import MY_SingleElementList
import os

Rasterizer.showMouse(1)

window_width = Rasterizer.getWindowWidth()
window_height = Rasterizer.getWindowHeight()

controller = GameLogic.getCurrentController()
owner = controller.owner
scene = GameLogic.getCurrentScene()

mouse = controller.sensors["mouse"]
mouseClick = controller.sensors["mouse_click"]
sNextSide = controller.sensors["next_side"]
sPrevSide = controller.sensors["prev_side"]
sEscape = controller.sensors["upper"]
#sEscape.key = GameKeys.ESCKEY
sExit = controller.sensors["exit"]

removeScene = controller.actuators["remove_scene"]
resumeScene = controller.actuators["resume_scene"]

inventoryCamera = scene.cameras["OBinventory_cam"]
inventoryCamera.setViewport(0, 0, window_width, window_height)
inventoryCamera.useViewport = True

inventoryList = MY_SingleElementList().collectionList

itemPos = scene.objects["OBitem_pos"]

itemPos.worldPosition = [-5, 0, 4]

config = MY_SingleConfigConnector()

if sNextSide.positive and len(config.collectionList) > (owner["side"]+1) * 10 and owner["show_info"] == "":
	itemPos["set"] = False
	owner["side"] += 1
	for text in MY_SingleElementList().littleInfoTextList:
		text.endObject()
	MY_SingleElementList().littleInfoTextList = []

if sPrevSide.positive and owner["side"] > 0 and owner["show_info"] == "":
	itemPos["set"] = False
	owner["side"] -= 1
	for text in MY_SingleElementList().littleInfoTextList:
		text.endObject()
	MY_SingleElementList().littleInfoTextList = []

temp_collection_list = []
if len(config.collectionList) <= (owner["side"]*10)+10:
	temp_collection_list = config.collectionList[owner["side"]*10:len(config.collectionList)]
else:
	temp_collection_list = config.collectionList[owner["side"]*10:(owner["side"]*10)+10]

if not itemPos["set"]:
	for idx, obj_name in enumerate(temp_collection_list):
		offset = Vector([0, 0, 2.0])
		if idx == 5:
			itemPos.worldPosition = [1.0, 0, 4.0]

		for j in scene.objectsInactive:
			print j.name[8:-4]
			if j.name[8:-4] == obj_name:
				item = scene.addObject(j, itemPos)
				inventoryList[obj_name] = item
				#infoText = open(os.path.expanduser('info/item_info.txt'), "r")
				infoText = open('resource/info/item_info.txt', "r")
				info_text = infoText.readline()
				info_set = False
				while not info_set:
					if info_text[:-1] == "[" + obj_name + "]":
						text_line = infoText.readline()
						while text_line[:-1] != "#info" and text_line != "":
							text_line = infoText.readline()
						text_line = infoText.readline()
						old_item_pos = itemPos.worldPosition
						itemPos.worldPosition = Vector(itemPos.worldPosition) + Vector([1.3, 0, 0.6])
						
						while (text_line != "" and text_line[0] != "#"):
							text_gauge = scene.addObject(scene.objectsInactive["OBinfo_text"], itemPos)
							MY_SingleElementList().littleInfoTextList.append(text_gauge)
							text_gauge.orientation = RotationMatrix(-90, 3, "x")
							text_gauge["Text"] = text_line
							text_line = infoText.readline()
							itemPos.worldPosition = Vector(itemPos.worldPosition) - Vector([0,0,0.5])
						info_set = True
						itemPos.worldPosition = old_item_pos	
					else:
						info_text = infoText.readline()
						
				itemPos.worldPosition = Vector(itemPos.worldPosition) - offset
				break

	itemPos["set"] = True

for i in scene.objects:
	if i.name[2:7] == "xItem":
		if owner["show_info"] != "":
			angle = owner["info_rot"]%360
			owner["show_info"].orientation = RotationMatrix(angle, 3, "z")
			owner["info_rot"] += 0.1
		else:
			angle = itemPos["rot"]%360
			i.orientation = RotationMatrix(angle, 3, "z")
			itemPos["rot"] += 0.1

		i.suspendDynamics()

add_value = 0
show_area = False
item_name = ""

aspect_ratio_factor = [window_width / 800.0, window_height / 600.0]
length_collection_list = len(temp_collection_list)

if mouse.position[0] > 0 and mouse.position[0] <= aspect_ratio_factor[0] * 180 and length_collection_list > 0:
	show_area = True
elif mouse.position[0] > aspect_ratio_factor * 400 and mouse.position[0] <= aspect_ratio_factor[0] * 580 and length_collection_list > 5:
	show_area = True
	add_value = 5

if show_area and owner["show_info"] == "":
	item_area = False
	for i in range(5):
		if mouse.position[1] <= (i+1) * (aspect_ratio_factor[1] * 120) and mouse.position[1] > i * (aspect_ratio_factor[1] * 120):
			row_number = i
			item_area = True
			
	if item_area and row_number + add_value < length_collection_list:
		item_name = temp_collection_list[row_number]

if mouseClick.positive:
	print "click"
	if item_name != "":
		itemPos.worldPosition = [-3.5,-2.5,0]
		for j in scene.objectsInactive:
			if j.name[8:] == item_name:
				item = scene.addObject(j, itemPos)
				item.localScale = [1.8, 1.8, 1.8]
				infoBg = scene.objects["OBinfo_bg"]
				infoBg.visible = True
				#infoText = open(os.path.expanduser('info/item_info.txt'), "r")
				infoText = open('resource/info/item_info.txt', "r")
				info_text = infoText.readline()
				info_set = False
				while not info_set:
					if info_text[:-1] == "[" + item_name + "]":
						text_line = infoText.readline()
						while text_line[:-1] != "#text" and text_line != "":
							text_line = infoText.readline()
						text_line = infoText.readline()
						itemPos.worldPosition = [-1, -0.15, 3.8]
						
						while (text_line != "" and text_line[0] != "["):
							text_gauge = scene.addObject(scene.objectsInactive["OBinfo_text"], itemPos)
							MY_SingleElementList().bigInfoTextList.append(text_gauge)
							text_gauge.orientation = RotationMatrix(-90, 3, "x")
							text_gauge["Text"] = text_line
							text_line = infoText.readline()
							itemPos.worldPosition = Vector(itemPos.worldPosition) - Vector([0,0,0.5])
						info_set = True
					else:
						info_text = infoText.readline()
				break
				
		owner["show_info"] = item
	elif owner["show_info"] != "":
		item = owner["show_info"]
		item.endObject()
		infoBg = scene.objects["OBinfo_bg"]
		infoBg.visible = False
		owner["show_info"] = ""
		for text in MY_SingleElementList().bigInfoTextList:
			text.endObject()
		MY_SingleElementList().bigInfoTextList = []

if sExit.positive or sEscape.positive:
	if owner["show_info"] == "":
		for text in MY_SingleElementList().littleInfoTextList:
			text.endObject()
		MY_SingleElementList().littleInfoTextList = []
		removeScene.scene = "inventory"
		controller.activate(removeScene)
		resumeScene.scene = "game"
		controller.activate(resumeScene)
	else:
		item = owner["show_info"]
		item.endObject()
		infoBg = scene.objects["OBinfo_bg"]
		infoBg.visible = False
		owner["show_info"] = ""
		for text in MY_SingleElementList().bigInfoTextList:
			text.endObject()
		MY_SingleElementList().bigInfoTextList = []
		
		
