from MyScene import MY_SingleScene
from MyGameObjects import *
from MyGameActiveParts import *
from MyGamePassiveParts import *
from MyGameActiveHidden import *
from MySpecialLists import MY_SingleElementList
from MyGameWorld import MY_SingleGameWorld
from MyControlKeys import MY_SingleControlKeys
from Mathutils import RotationMatrix, Vector
from MyConfigConnector import MY_SingleConfigConnector
import Rasterizer

print "----------------BEGIN INIT----------------"

window_width = Rasterizer.getWindowWidth()
window_height = Rasterizer.getWindowHeight()

Rasterizer.setMousePosition(window_width/2, window_height/2)

scene = GameLogic.getCurrentScene()
controller = GameLogic.getCurrentController()
owner = controller.owner

owner["init"] = False

if not MY_SingleConfigConnector().loaded:
	MY_SingleConfigConnector().setDefault()
	MY_SingleConfigConnector().loaded = True

myScene = MY_SingleScene()
myScene.scene = scene
myWorld = MY_SingleGameWorld()
myWorld.setDefaultWorld()
myControlKeys = MY_SingleControlKeys()
myControlKeys.setControlKeys()
myControlKeys.init = False

myElementList = MY_SingleElementList()
myElementList.setStairIndexList(scene)
myElementList.setItemIndexList(scene)
myElementList.setMerchList(scene)

# init game elements
myCharacter = MY_GameCharacter(scene, "character")

myCharacter.mag = 5
myCharacter.reloadAmmo()
myCharacter.rotationPointObject = scene.objects["OBcharacter_rot_center"]
myCharacter.setView([window_width, window_height])
#myCharacter.inventoryList.fillWithConfigValues()
myCharacter.setInventoryGauge()

mySkySphere = MY_SkySphere(scene, "sky_sphere")

myStartText = MY_GameGauge(scene, "osd", True)
myStartText.setVisible(False)
myStartText.setPosition(scene.objects["OBosd"].worldPosition)

myHurdleTimer = MY_GameGauge(scene, "timer", False)
myHurdleTimer.setPosition(scene.objects["OBtimer"].worldPosition)
myHurdleTimer.theText = 10
myHurdleTimer.setText()

# init lights for sky illumination
mySkyLampXY = MY_SkyLight(scene, "sky_lamp1", "sky_lamp_xy")
mySkyLampXY.setEnergy(0)

mySkyLampXZ = MY_SkyLight(scene, "sky_lamp2", "sky_lamp_xz")
mySkyLampXZ.setEnergy(0)

mySkyLampYZ = MY_SkyLight(scene, "sky_lamp3", "sky_lamp_yz")
mySkyLampYZ.setEnergy(0)

myFirstPlatform = MY_GamePlatform(scene)
myFirstPlatform.setElement([0, [0, 0, 0]], 0, 2, 1)

# init cameras and viewports
myFirstPersonCam = MY_GameCamera(scene, "fpc")
myFirstPersonCam.gObject.setViewport(0, 0, window_width, window_height)
myFirstPersonCam.gObject.useViewport = True
myThirdPersonCam = MY_GameCamera(scene, "tpc")
myThirdPersonCam.gObject.setViewport(0, 0, window_width/4, window_height/4)
myThirdPersonCam.gObject.useViewport = True
myFirstPersonCam.gObject.setOnTop()

#myBackSightCam = MY_GameCamera(scene, "bsc")

myWorld.setGravityDirection(myCharacter.getWorldOrientation())
myWorld.deleteDelay = 3
myWorld.specialKeys = True
myWorld.isPaused = True
myWorld.boxIntro = True

bgSound = controller.actuators["bg_sound"]
controller.activate(bgSound)

print "-----------------END INIT-----------------"
print ""

