import Rasterizer
import VideoTexture
import GameKeys

### rasterizer
Rasterizer.showMouse(1)
window_width = Rasterizer.getWindowWidth()
window_height = Rasterizer.getWindowHeight()

#### scene params
scene = GameLogic.getCurrentScene()
controller = GameLogic.getCurrentController()
owner = controller.owner
obj = scene.objects["OBcredits_bg"]

### sensors
quitCredits = controller.sensors["back"]
quitCredits.key = GameKeys.QKEY
mouseOver = controller.sensors["mouse_over"]
sEscape = controller.sensors["upper"]
#sEscape.key = GameKeys.ESCKEY
showDemo = controller.sensors["demo"]

### actuators
rollUp = controller.actuators["roll_up"]
rollDown = controller.actuators["roll_down"]
rollRoll = controller.actuators["roll_roll"]
createScene = controller.actuators["set_scene"]
removeScene = controller.actuators["remove_scene"]

### camera
camera = scene.cameras["OBcredits_cam"]
camera.setViewport(0, 0, window_width, window_height)
camera.useViewport = True

"""
# check to see video has been added
if owner["show_demo"]:
	if obj.has_key("Video") == True:
	
		# get video 
		video = obj["Video"]
	
		# update the video 
		video.refresh(True)
						
	# if video hasn't been added 
	else:
		# get matID for the movie screen
		matID = VideoTexture.materialID(obj, "MA" + owner['material'])
		# get the texture
		video = VideoTexture.Texture(obj, matID)
	
		movieName = owner['movie']
	
		# get movie path
		movie = GameLogic.expandPath('//textures/' + movieName)
	
		# get movie
		video.source = VideoTexture.VideoFFmpeg(movie)
	
		# set scaling
		video.source.scale = True	
	
		# save video as an object variable
		obj["Video"] = video
	
		# check for optional loop property
		if owner.has_key("loop") == True:
		
			# loop it forever
			if owner['loop'] == True:
				video.source.repeat = -1
	
			# no looping
			else:
				video.source.repeat = 0
	
		# start the video
		video.source.play()
else:
	# get matID for the movie screen
	matID = VideoTexture.materialID(obj, "MA" + owner['material'])
	# get the texture
	video = VideoTexture.Texture(obj, matID)

	movieName = owner['movie']

	# get movie path
	movie = GameLogic.expandPath('//textures/' + movieName)

	# get movie
	video.source = VideoTexture.VideoFFmpeg(movie)
	
	video.source.stop
"""

if showDemo.positive and owner["show_demo"]:
	owner["show_demo"] = False
elif showDemo.positive and not owner["show_demo"]:
	owner["show_demo"] = True

if mouseOver.triggered and owner["rolled_up"] == False and owner["roll_start"] == 0:
	controller.deactivate(rollDown)
	controller.activate(rollUp)
	controller.activate(rollRoll)	
	owner["roll_start"] = owner["now"]
	owner["rolled_up"] = True
elif mouseOver.triggered and owner["rolled_up"] == True and owner["roll_start"] == 0:
	controller.deactivate(rollUp)
	controller.deactivate(rollRoll)	
	controller.activate(rollDown)
	owner["roll_start"] = owner["now"]
	owner["rolled_up"] = False

if quitCredits.positive or sEscape.positive:
	removeScene.scene = "credits"
	controller.activate(removeScene)
	createScene.scene = "menu"
	controller.activate(createScene)

if owner["now"] - owner["roll_start"] >= rollUp.frameEnd / 30.0:
	owner["roll_start"] = 0


