from random import randint
from MyConfigConnector import MY_SingleConfigConnector

class MY_SingleIdList(object):
	"""
	singleton class to hold unique ids for game objects
	
	@ivar idList: the list of the used id's in the game
	@type idList: List of Integer
	"""
	
	__instance = None  # the unique instance

	def __new__(self, *args, **kargs):
		if self.__instance is None:
			self.__instance = object.__new__(self, *args, **kargs)
			
			# __init__ section
			self.idList = []
			
		return self.__instance

	def __init__(self):
		pass

	def getElementId(self):
		"""
		gets a free id for any game object
		
		@rtype: Integer
		@return: returns a free id that can be used for a unique game element
		"""
		
		free_id = 0
		free = False
		liste = self.idList
		while not free:
			old_id = free_id
			for i in liste:
				if free_id == i:
					free_id += 1
					break
			if free_id == old_id:
				free = True
				break

		# sorts the list, but why?!
		if len(liste) > 0:
			for i in range(len(liste)):
				if free_id > liste[len(liste)-1]:
					liste.append(free_id)
					break

				if free_id < liste[i]:
					n = i
					old_i = liste[n]
					while n != len(liste)-1:
						temp = liste[n+1]
						liste[n+1] = old_i
						old_i = temp
						n += 1
					liste.append(old_i)
					liste[i] = free_id
					break
		else:
			liste.append(free_id)
		
		return free_id

	def setElementId(self, free_id):
		"""
		sets an id free for further use
		
		@type free_id: Integer
		@param free_id: the id that can be freed out of the idList
		"""
		
		self.idList.remove(free_id)

class MY_SingleElementList(object):
	"""
	singleton class which holds lists for all ingame stairs, items, hurdles and bullets
	
	@ivar stairList: the list that conatins all stairs and patforms that exists for the game (NOT in the game)
	@type stairList: List of Blender scene indices
	@ivar itemList: the list that conatins all items that exists for the game (NOT in the game)
	@type itemList: List [Blender scene indices, KX_GameObject]
	@ivar merchList: the list that conatins all merch items that exists for the game (NOT in the game, so there is a static length per game of this list )
	@type merchList: List of KX_GameObject
	@ivar merchObjectList: the list that conatins all merch objects that are used in the game (because linked objects appear twice, so this was a simple workaround to get a faultless game, sorry)
	@type merchObjectList: List of KX_GameObject
	"""
	
	__instance = None  # the unique instance

	def __new__(self, *args, **kargs):
		if self.__instance is None:
			self.__instance = object.__new__(self, *args, **kargs)
			
			# __init__ section
			self.stairList = []
			self.itemList = []
			self.merchList = []
			self.merchObjectList = []
			self.collectionList = {}
			self.littleInfoTextList = []
			self.bigInfoTextList = []

		return self.__instance

	def __init__(self):
		pass

	def setStairIndexList(self, scene):
		"""
		sets the stair list filled with their indices, to get a random/specific stair later
		
		@type scene: KX_Scene
		@param scene: the blender scene object which holds all objects
		"""
		
		for i, obj in enumerate(scene.objectsInactive):
			if obj.name[2:7] == "stair":
				self.stairList.append(i)
	
	def setItemIndexList(self, scene):
		"""
		sets the item list, filled with their indices, to get a random/specific item later
		
		@type scene: KX_Scene
		@param scene: the blender scene object which holds all objects
		"""
		
		for i, obj in enumerate(scene.objectsInactive):
			name = "OB" + obj.name[7:]
			if obj.name[2:6] == "item":
				self.itemList.append([i, obj])
			
	def setMerchList(self, scene):
		"""
		creates a list of all merchandise items
		
		@type scene: KX_Scene
		@param scene: the blender scene object which holds all objects
		"""
		
		for obj in scene.objectsInactive:
			if obj.name[2:7] == "xItem":
				self.merchList.append(obj)
		

class MY_InventoryList():
	"""
	class for the player's inventory with all needed methods
	
	@ivar inventoryList: the list that contains the players skill levels (health etc.). one skill => [number of dose, item name, lifetime]
	@type inventoryList: List of List [[Integer, String, Integer], ...]
	"""
	
	def __init__(self):
		self.inventoryList = []

	def __getitem__(self, name):
		for i in self.inventoryList:
			if i[1] == name:
				return i
		return "none"
	
	def fillWithConfigValues(self):
		"""
		sets the inventory with values from the config parser
		"""
		
		self.inventoryList = []
		myElementList = MY_SingleElementList().itemList
		
		for i in range(len(myElementList)):
			item = myElementList[i][1]
			self.inventoryList.append([MY_SingleConfigConnector().getPowerUpValue(item.name[7:]), item.name[7:], item["life_time"], item["life_time"]])
	
	def useItem(self, item_name, add):
		"""
		adds or remove an item from  its list and the config parser
		
		@type item_name: String
		@param item_name: the nameof the item that shall be used
		@type add: Boolean
		@param add: True if an item was collected, False if item was used
		
		@rtype: Boolean
		@return: 'True' if the item exists, else 'False'
		"""
		
		item = self[item_name]
		exist = False
		if not add:
			if item[0] >= 1:
				if item[3] != 0:
					item[2] -= 1
				item[0] -= 1
				exist = True
				if item_name == "health" and item[0] == 0:
					exist = False
		elif add:
			if item_name == "sniper":
				item[0] += item[3]
			else:
				item[0] += 1
			exist = True

		MY_SingleConfigConnector().setPowerUps(item[1], item[0])

		return exist
	
	def addMerchItem(self, merch_name):
		"""
		adds a merchandise item to the config parser
		
		@type merch_name: String
		@param merch_name: the name of the merhcandise item that was collected
		"""
		
		MY_SingleConfigConnector().setMerch(merch_name)


