class MY_SingleScene(object):
	"""
	singleton class of the used game scene to hold all the created objects
	
	@ivar objectsActive: all objects that are active like player and the universe sphere
	@type objectsActive: List
	@ivar objectsPassive: all stairs and platforms in the game scene
	@type objectsPassive: List
	@ivar objectsCamera: all cameras in the game scene
	@type objectsCamera: List
	@ivar objectsLight: all the lights in the game scene
	@type objectsLight: List
	@ivar objectsActiveTemp: all objects that are temporary available in the game scene like items, hurdle, gauge
	@type objectsActiveTemp: List
	@ivar objectsMerch: all objects that are classified as xItem and were spawned into game scene
	@type objectsMerch: List
	@ivar scene: holds the blender game scene
	@type scene: KX_Scene
	"""
	
	__instance = None  # the unique instance

	def __new__(self, *args, **kargs):
		if self.__instance is None:
			self.__instance = object.__new__(self, *args, **kargs)
			
			# __init__ section
			self.objectsActive = []
			self.objectsPassive = []
			self.objectsCamera = []
			self.objectsLight = []
			self.objectsActiveTemp = []
			self.objectsMerch = []
			self.scene = 0
			
		return self.__instance

	def __init__(self):
		pass

	def addObject(self, my_object=None):
		"""
		adds a given object to his predefined list
		
		@type my_object: MY_GameObject
		@param my_object: the object that shall be added to the scene
		"""
		
		if my_object.type == "objectActive":
			self.objectsActive.append(my_object)
		elif my_object.type == "objectPassive":
			self.objectsPassive.append(my_object)
		elif my_object.type == "objectCamera":
			self.objectsCamera.append(my_object)
		elif my_object.type == "objectLight":
			self.objectsLight.append(my_object)
		elif my_object.type == "objectActiveTemp":
			self.objectsActiveTemp.append(my_object)
		elif my_object == None:
			print "no object added"

	def removeObject(self, my_object=None):
		"""
		removes an object from his scene list
		
		@type my_object: MY_GameObject
		@param my_object: the object that shall be removed from the scene
		"""
		
		if my_object.type == "objectActive":
			self.objectsActive.remove(my_object)
		elif my_object.type == "objectPassive":
			self.objectsPassive.remove(my_object)
		elif my_object.type == "objectCamera":
			self.objectsCamera.remove(my_object)
		elif my_object.type == "objectLight":
			self.objectsLight.remove(my_object)
		elif my_object.type == "objectActiveTemp":
			self.objectsActiveTemp.remove(my_object)
		elif my_object == None:
			print "no object deleted"

	def __getitem__(self, item):
		"""
		only for non passive elements, passive lements can be searched by id (.getMyPassiveObjectById())
		"""
		
		for element in self.objectsActive:
			if element.name == item:
				return element

		for element in self.objectsCamera:
			if element.name == item:
				return element

		for element in self.objectsLight:
			if element.name == item:
				return element
				
		for element in self.objectsActiveTemp:
			if element.name == item:
				return element

	def getMyPassiveObjectById(self, object_id):
		"""
		gets a passive object by it's given id, like platforms and stairs
		
		@type object_id: Integer
		@param object_id: the id of a passive object
		
		@rtype: MY_GameObject
		@return: returns the passive object that goes with the given id
		"""
		
		result = None

		for index, element in enumerate(self.objectsPassive):
			if element.elementId == object_id:
				result = element
		return result
		
	def getMyActiveTempObjectById(self, item_id):
		"""
		gets a temporary active object by it's given id, like items 
		
		@type item_id: Integer
		@param item_id: the id of a temporary active object
		
		@rtype: MY_GameObject
		@return: returns the temporary active object that goes with the given id
		"""
		
		result = None
		
		for index, element in enumerate(self.objectsActiveTemp):
			if element.elementId == item_id:
				result = element
		
		return result

	def freeLists(self):
		"""
		free the lists and destroy all game objects (when game is over for example)
		"""
		
		temp_list = self.objectsActive[:]
		for i in temp_list:
			i.deleteObject()
		temp_list = self.objectsPassive[:]
		for i in temp_list:
			i.deleteObject(True, False)
		temp_list = self.objectsCamera[:]
		for i in temp_list:
			i.deleteObject()
		temp_list = self.objectsLight[:]
		for i in temp_list:
			i.deleteObject()
		temp_list = self.objectsActiveTemp[:]
		for i in temp_list:
			i.deleteObject()
		while self.objectsMerch != []:
			self.objectsMerch[0].deleteObject()
		del temp_list

		print self.objectsActive
		print self.objectsPassive
		print self.objectsCamera
		print self.objectsLight
		print self.objectsActiveTemp
		print self.objectsMerch

		
