from math import cos, sin, pi, ceil, fabs
from Mathutils import RotationMatrix
from MyScene import MY_SingleScene

def GetBoxCollision(obj1, obj2):
	"""
	calculates the collsion of game objects, like patforms and stairs
	
	@rtype: Boolean
	@return: 'False' if there is a coillision, else 'True'
	"""
	
	intersection = False
	
	return intersection

def SetReverseRootConnection(root_ground):
	"""
	sets the right id as the root connected id
	
	@type root_ground: MY_GameObject
	@param root_ground: the object that represents the current ground object of the player
	"""

	for idx, child_object in root_ground.connectedSides.iteritems():
		if child_object != None:
			if child_object.rootConnectObject == None:
				child_object.rootConnectObject = root_ground
			
			if child_object.rootConnectObject != root_ground:
				child_object.rootConnectObject = root_ground
				SetReverseRootConnection(child_object)

def GetGlobalOrientationToMe(source_object, target_object):
	"""
	gets the global direction of an object to me (at top, bottom, left, right, front or back)
	question is: where is an object from my point of view (globally)?
	
	@type source_object: MY_GameObject
	@param source_object: the source object to whom you want the orientation to (dont know how to explain!)
	@type target_object: MY_GameObject
	@param target_object: the object you want the orientation to (dont know how to explain!)
	
	@rtype: String
	@return: returns a string that represents the direction where to find the target object (top, bottom, left, right, front, back or none)
	"""
	
	source_pos = source_object.getPosition()
	source_plane = source_object.worldPlane
	target_pos = target_object.getPosition()
	target_plane = target_object.worldPlane
	
	side = "none"
	
	if (source_plane == 0 and target_plane == 1) or (source_plane == 1 and target_plane == 0) or (source_plane == 2 and target_plane == 0):
		in_front_of_me = 0
	
		if source_plane == 0:
			if target_pos[1] > source_pos[1]:
				in_front_of_me = 1
		elif source_plane == 1 or source_plane == 2:
			if target_pos[2] > source_pos[2]:
				in_front_of_me = 1
	
		if in_front_of_me:
			side = "front"
		else:
			side = "back"
		
	elif (source_plane == 0 and target_plane == 2) or (source_plane == 1 and target_plane == 2) or (source_plane == 2 and target_plane == 1):	
		left_of_me = 0
	
		if source_plane == 0 or source_plane == 1:
			if target_pos[0] < source_pos[0]:
				left_of_me = 1
		elif source_plane == 2:
			if target_pos[1] > source_pos[1]:
				left_of_me = 1
	
		if left_of_me:
			side = "left"
		else:
			side = "right"
	
	elif source_plane == target_plane:	

		if source_plane == 0:
			if target_pos[2] < source_pos[2]:
				side = "top"
			else:
				side = "bottom"
		elif source_plane == 1:
			if target_pos[1] < source_pos[1]:
				side = "back"
			else:
				side = "front"
		elif source_plane == 2:
			if target_pos[0] < source_pos[0]:
				side = "left"
			else:
				side = "right"
	return side	


######## Set inter connection between two passive objects
def SetPassivePartsConnection(connected_side, source, target):
	"""
	sets the connected list of source and target object, so both know they are connected
	
	@type connected_side: Integer (0,1,2,3)
	@param connected_side: the connected side of source (passive) object where the target (passive) object is connected to
	@type source: MY_GameObject
	@param source: the object where the target is connected to
	@type target: MY_GameObject
	@param target: the object which is connected to source
	"""

	opposite_side = (connected_side + 2) % 4
	
	if source.worldPlane == 0:
		if target.isRotated == 0:
			opposite_side = 0
		elif target.isRotated == 1:
			opposite_side = 2
	elif source.worldPlane == 1:
		if connected_side == 0 or connected_side == 2:
			if target.isRotated == 0:
				opposite_side = 0
			elif target.isRotated == 1:
				opposite_side = 2
		elif connected_side == 1 or connected_side == 3:
			if target.isRotated == 0:
				opposite_side = 3
			elif target.isRotated == 1:
				opposite_side = 1
	elif source.worldPlane == 2:
		if connected_side == 0 or connected_side == 2:
			if target.isRotated == 0:
				opposite_side = 1
			elif target.isRotated == 1:
				opposite_side = 3
		elif connected_side == 1 or connected_side == 3:
			if target.isRotated == 0:
				opposite_side = 1
			elif target.isRotated == 1:
				opposite_side = 3
	
	source.setConnectedSide(connected_side, target)
	target.setConnectedSide(opposite_side, source)

	target.rootConnectObject = source


######## Get object rotation in same plane as the connected object
def GetNormRotation(direction, plane, up=1):
	"""
	gets a normal rotation for an object dependent on the three planes and four direction; in the same plane as the connected object (mostly for stair objects)
	
	@type direction: Integer (0,1,2,3)
	@param direction: the direction where an object is connected to
	@type plane: Integer (0,1,2)
	@param plane: the plane of the object that makes a normal rotation
	@type up: Boolean
	@param up: True if object is turned upwards
	
	@rtype: Matrix
	@return: returns the rotation matrix of a 'normal' rotation
	"""
	
	ninety	= 90
	oneighty= 180
	
	angle_x = 0
	angle_y = 0
	angle_z = 0
	angle = 0
	
	if not up:
		angle = oneighty

	rot_up = RotationMatrix(angle, 3, "y")
	
	if (plane == 0):
		if (direction == 0):
			pass
		elif (direction == 1):
			angle_z = ninety
		elif (direction == 2):
			angle_z = oneighty 
		elif (direction == 3):
			angle_z = -ninety

	elif (plane == 1):
		if (direction == 0):
			angle_y = oneighty
			angle_x = -ninety
		elif (direction == 1):
			angle_z = ninety
			angle_x = ninety
		elif (direction == 2):
			angle_x = ninety
		elif (direction == 3):
			angle_z = -ninety
			angle_x = ninety
	
	elif (plane == 2):
		if (direction == 0):
			angle_z = -ninety
			angle_y = -ninety
		elif (direction == 1):
			angle_z = oneighty
			angle_y = -ninety
		elif (direction == 2):
			angle_z = ninety
			angle_y = -ninety
		elif (direction == 3):
			angle_y = -ninety

	rot_x = RotationMatrix(angle_x, 3, "x")
	rot_y = RotationMatrix(angle_y, 3, "y")
	rot_z = RotationMatrix(angle_z, 3, "z")
	
	tot_rot = ((rot_x * rot_y) * rot_z) * rot_up

	return tot_rot


######## Set object loaction
def GetPlatfNormTransDelta(cur_pos, direction, plane, o_width, direct=0):
	"""
	gets the position of a platform by a normal translation with an offset (because of creepy center points)
	
	@type cur_pos: Vector
	@param cur_pos: the object's current position
	@type direction: Integer (0,1,2,3)
	@param direction: the direction of the object where it is connected to
	@type plane: Integer (0,1,2)
	@param plane: the plane of the object that makes the TransDelta 
	@type o_width: Integer
	@param o_width: the width of an object in the xy-plane; only for platforms!!!
	@type direct: Boolean
	@param direct: True if the object dont have to make a translation (for example: only one platform will be spawned in the game)
	
	@rtype: Vector
	@return: the new position after a normal translation with a delta
	"""
	
	if direct:
		o_width = 0
	
	pos_delta = []
	
	new_pos = cur_pos[:]
	
	if (plane == 0):
		if (direction == 0):
			new_pos[1] += o_width
		elif (direction == 1):
			new_pos[0] += o_width
		elif (direction == 2):
			new_pos[1] -= o_width
		elif (direction == 3):
			new_pos[0] -= o_width
			
	elif (plane == 1):
		if (direction == 0):
			new_pos[2] += o_width
		elif (direction == 1):
			new_pos[0] += o_width
		elif (direction == 2):
			new_pos[2] -= o_width
		elif (direction == 3):
			new_pos[0] -= o_width
	
	elif (plane == 2):
		if (direction == 0):
			new_pos[2] += o_width
		elif (direction == 1):
			new_pos[1] -= o_width
		elif (direction == 2):
			new_pos[2] -= o_width
		elif (direction == 3):
			new_pos[1] += o_width

	return new_pos


######## Set object loaction
def GetPlatfVertTransDelta(cur_pos, direction, plane, o_width, o_height, up):	
	"""
	gets the new position of a platform, when it's rotated
	
	@type cur_pos: Vector
	@param cur_pos: the object's current position
	@type direction: Integer (0,1,2,3)
	@param direction: the direction of the object where it is connected to
	@type plane: Integer (0,1,2)
	@param plane: the plane of the object that makes the TransDelta 
	@type o_width: Integer
	@param o_width: the width of an object in the xy-plane; only for platforms!!!
	@type o_height: Integer
	@param o_height: the height of an object in the xy-plane; only for platforms!!!
	@type up: Boolean
	@param up: True if object is turned upward, False when downward (this 'def' is for platforms that are already defined as rotated)
	
	@rtype: Vector
	@return: returns the new position after a translation with delta of an already rotated object
	"""
	
	new_pos = cur_pos[:]
	
	t_height = o_height + o_width
	
	if (up):
		sign = 1
	else:
		sign = -1
	
	if (plane == 0):
		new_pos[2] += sign * t_height
		
		if (direction == 0):
			new_pos[1] -= o_height
		elif (direction == 1):
			new_pos[0] -= o_height
		elif (direction == 2):
			new_pos[1] += o_height
		elif (direction == 3):
			new_pos[0] += o_height
			
	elif (plane == 1):
		new_pos[1] += sign * t_height
		
		if (direction == 0):
			new_pos[2] -= o_height
		elif (direction == 1):
			new_pos[0] -= o_height
		elif (direction == 2):
			new_pos[2] += o_height
		elif (direction == 3):
			new_pos[0] += o_height
	
	elif (plane == 2):
		new_pos[0] += sign * t_height
		
		if (direction == 0):
			new_pos[2] -= o_height
		elif (direction == 1):
			new_pos[1] += o_height
		elif (direction == 2):
			new_pos[2] += o_height
		elif (direction == 3):
			new_pos[1] -= o_height
	
	return new_pos


######## Set object rotation
def GetVertRotation(direction, plane):
	"""
	gets the rotation for an object if it is rotated (and changed to a new plane)
	
	@type direction: Integer (0,1,2,3)
	@param direction: the direction of the object where it is connected to
	@type plane: Integer (0,1,2)
	@param plane: the plane of the object that makes this rotation
	
	@rtype: Matrix
	@return: returns the rotation matrix of a rotation when an object was already defined as rotated
	"""
	
	ninety	= 90
	oneighty= 180
	
	angle_x = 0
	angle_y = 0

	if (plane == 0):	
		if (direction == 0 or direction == 2):
			angle_x = ninety
		elif (direction == 1 or direction == 3):
			angle_y = ninety
	
	elif (plane == 1):
		if (direction == 0 or direction == 2):
			pass
		elif (direction == 1 or direction == 3):
			angle_y = ninety
				
	elif (plane == 2):
		if (direction == 0 or direction == 2):
			pass
		elif (direction == 1 or direction == 3):
			angle_x = ninety
	
	rot_x = RotationMatrix(angle_x, 3, "x")
	rot_y = RotationMatrix(angle_y, 3, "y")

	tot_rot = rot_x * rot_y
	
	return tot_rot	


