from MyScene import MY_SingleScene

class MY_SingleTimer(object):
	"""
	singleton class of the ingame timer; to know what time it is ;)
	
	@cvar NOW: the current time in the game
	@type NOW: Float
	@cvar AGO: the last set current game time
	@type AGO: Float
	"""
	
	__instance = None  # the unique instance
	NOW = 0
	AGO = 0

	def __new__(self, *args, **kargs):
		if self.__instance is None:
			self.__instance = object.__new__(self, *args, **kargs)
			
			# __init__ section
			#self.NOW = 0
			#self.AGO = 0
						
		return self.__instance

	def __init__(self):
		pass

	def setCurrentTime(self, scene):
		"""
		sets the current game time
		
		@type scene: KX_Scene
		@param scene: the blender game scene where all objects are bind to
		"""
		
		self.NOW = scene.objects["OBcenter"]["now"]
	
	def setPassedTime(self, scene):
		"""
		sets the iassed ingame time
		
		@type scene: KX_Scene
		@param scene: the blender game scene where all objects are bind to
		"""
		
		self.AGO = self.NOW


