import GameKeys
from MyConfigConnector import MY_SingleConfigConnector

class MY_SingleControlKeys(object):
	"""
	singleton class to control the keyboard input
	@type FWD_key: Integer
	@ivar FWD_key: ascii code of the keystroke for forward movement
	@type BWD_key: Integer
	@ivar BWD_key: ascii code of the keystroke for backward movement
	@type DXR_key: Integer
	@ivar DXR_key: ascii code of the keystroke for dexter movement
	@type SNL_key: Integer
	@ivar SNL_key: ascii code of the keystroke for sinsitral movement
	@type UWD_key: Integer
	@ivar UWD_key: ascii code of the keystroke for upward movement
	@type DWD_key: Integer
	@ivar DWD_key: ascii code of the keystroke for downward movement
	@type FWD: SCA_KeyboardSensor
	@ivar FWD: keyboard sensor which listens to a specific keystroke
	@type BWD: SCA_KeyboardSensor
	@ivar BWD: keyboard sensor which listens to a specific keystroke
	@type DXR: SCA_KeyboardSensor
	@ivar DXR: keyboard sensor which listens to a specific keystroke
	@type SNL: SCA_KeyboardSensor
	@ivar SNL: keyboard sensor which listens to a specific keystroke
	@type UWD: SCA_KeyboardSensor
	@ivar UWD: keyboard sensor which listens to a specific keystroke
	@type DWD: SCA_KeyboardSensor
	@ivar DWD: keyboard sensor which listens to a specific keystroke
	@type init: Boolean
	@ivar init: True if controlkeys were initialized
	"""
	
	__instance = None  # the unique instance
	
	def __new__(self, *args, **kargs):
		if self.__instance is None:
			self.__instance = object.__new__(self, *args, **kargs)
			
			# __init__ section
			# ascii key values
			self.FWD_key = 0
			self.BWD_key = 0
			self.DXR_key = 0
			self.SNL_key = 0
			self.UWD_key = 0
			self.DWD_key = 0
			
			# sensor variables
			self.FWD = None
			self.BWD = None
			self.DXR = None
			self.SNL = None
			self.UWD = None
			self.DWD = None
			
			self.init = False
						
		return self.__instance

	def __init__(self):
		pass
	
	def initControlKeys(self, controller):
		"""
		set sensors to the right variables
		
		@type controller: SCA_IController
		@param controller: the controller on which the keyboard sensors are connected to
		"""
		
		self.FWD = controller.sensors["forward"]
		self.BWD = controller.sensors["back"]
		self.DXR = controller.sensors["right"]
		self.SNL = controller.sensors["left"]
		self.UWD = controller.sensors["jump"]
		self.DWD = controller.sensors["crouch"]
		
		self.init = True
	
	def setControlKeys(self):
		"""
		reads ascii key values from the config list and sets it to the right memeber variables
		"""
		
		self.FWD_key = MY_SingleConfigConnector().getControlKeyValue('fwd')
		self.BWD_key = MY_SingleConfigConnector().getControlKeyValue('bwd')
		self.DXR_key = MY_SingleConfigConnector().getControlKeyValue('dxr')
		self.SNL_key = MY_SingleConfigConnector().getControlKeyValue('snl')
		self.UWD_key = MY_SingleConfigConnector().getControlKeyValue('uwd')
		self.DWD_key = MY_SingleConfigConnector().getControlKeyValue('dwd')

	def setControlKeysEffect(self, plane=0, opposite=False):
		"""
		change key assignments dependent on which plane is in use; normal use without any effect just call this method without any parameters
		
		@type plane: Integer [0,1,2]
		@param plane: the plane number on which the user is right now
		@type opposite: Boolean
		@param opposite: whether it is the up or down on the specific plane
		"""
		
		if plane == 0:
			if opposite:
				self.FWD.key = self.BWD_key
				self.BWD.key = self.FWD_key
				self.DXR.key = self.DXR_key
				self.SNL.key = self.SNL_key
				self.UWD.key = self.DWD_key
				self.DWD.key = self.UWD_key
			else:
				self.FWD.key = self.FWD_key
				self.BWD.key = self.BWD_key
				self.DXR.key = self.DXR_key
				self.SNL.key = self.SNL_key
				self.UWD.key = self.UWD_key
				self.DWD.key = self.DWD_key
		elif plane == 1:
			if opposite:
				self.FWD.key = self.DWD_key
				self.BWD.key = self.UWD_key
				self.DXR.key = self.DXR_key
				self.SNL.key = self.SNL_key
				self.UWD.key = self.FWD_key
				self.DWD.key = self.BWD_key
			else:
				self.FWD.key = self.UWD_key
				self.BWD.key = self.DWD_key
				self.DXR.key = self.DXR_key
				self.SNL.key = self.SNL_key
				self.UWD.key = self.BWD_key
				self.DWD.key = self.FWD_key
				
		elif plane == 2:
			if opposite:
				self.FWD.key = self.FWD_key
				self.BWD.key = self.BWD_key
				self.DXR.key = self.DWD_key
				self.SNL.key = self.UWD_key
				self.UWD.key = self.DXR_key
				self.DWD.key = self.SNL_key
			else:
				self.FWD.key = self.FWD_key
				self.BWD.key = self.BWD_key
				self.DXR.key = self.UWD_key
				self.SNL.key = self.DWD_key
				self.UWD.key = self.SNL_key
				self.DWD.key = self.DXR_key
		else:
			print "nothing changed"


