#import ConfigParser
import GameKeys
from random import randint
import os.path

class MY_SingleConfigConnector(object):
	"""
	singleton class to parse the config file
	
	@author: Niner
	@contact: Admiral.Niner@googlemail.com
	
	@cvar __instance: private class variable to check if singleteon is initilized
	@type __instance: object
	
	@ivar ram: True if config file is not writable
	@type ram: Boolean
	@ivar keyList: a list of the ascii values for the specific keystrokes
	@type keyList: List
	@ivar powerupsList: a list of the number of collected powerups
	@type powerupsList: List
	@ivar collectionList: a list of the collected merhcandise objects
	@type collectionList: List
	@ivar loaded: True if config file was loaded and set
	@type loaded: Boolean
	"""
	
	__instance = None  # the unique instance

	def __new__(self, *args, **kargs):
		if self.__instance is None:
			self.__instance = object.__new__(self, *args, **kargs)
			
			# __init__ section
			self.ram = False
			self.keyList = []
			self.powerupsList = []
			self.collectionList = []
			self.loaded = False
						
		return self.__instance

	def __init__(self):
		pass
	
	def getConfig(self):
		"""
		checks if file exists and is writable
		otherwise create it with default values
		or throw exception when user has wrong privileges
		
		@rtype: Boolean
		@return: True if config was loaded, otherwise False
		"""
		result = False
		try:
			configfile = open(os.path.expanduser('~/stairs.cfg'), "a+")

			error = False
			configfile.close()
			configfile = open(os.path.expanduser('~/stairs.cfg'), "r")
			self.setDefault()
			self.ram = False
			option = configfile.readline()
			
			while (option != ""):
				result = True
				if option[:-1] == "[keycontrol]":
					key_count = 0
					option = configfile.readline()
					while (option != "" and option[0] != "["):
						if key_count >= 6:
							error = True
						values = option[:-1].split("=")
						self.setControlKeyValue(values[0], int(values[1]))
						option = configfile.readline()
						key_count += 1
					
				if option[:-1] == "[powerups]":
					key_count = 0
					option = configfile.readline()
					while (option != "" and option[0] != "["):
						if key_count >= 6:
							error = True
						values = option[:-1].split("=")
						self.setPowerUps(values[0], int(values[1]))
						option = configfile.readline()
						key_count += 1
						
				if option[:-1] == "[collecteditems]":
					option = configfile.readline()
					while (option != "" and option[0] != "["):
						self.setMerch(option[:-1])
						option = configfile.readline()

			configfile.close()
		
		except IOError:
			print "wrong privileges to create config file"
			self.setDefault()
			self.ram = True
		if result:
			self.loaded = True
		
		return result
					
	def setDefault(self):
		"""
		set input keys to default (awsd) and fills properties with random values
		"""
		
		self.keyList = []
		self.keyList.append(['fwd', GameKeys.WKEY])
		self.keyList.append(['bwd', GameKeys.SKEY])
		self.keyList.append(['dxr', GameKeys.DKEY])
		self.keyList.append(['snl', GameKeys.AKEY])
		self.keyList.append(['uwd', GameKeys.SPACEKEY])
		self.keyList.append(['dwd', GameKeys.LEFTSHIFTKEY])
		
		self.powerupsList = []
		amount = randint(1,4)
		self.powerupsList.append(['health', amount])
		amount = randint(1,4)
		self.powerupsList.append(['newplatf', amount])
		amount = randint(1,4)
		self.powerupsList.append(['power', amount])
		amount = randint(1,4)
		self.powerupsList.append(['ammo', amount])
		amount = randint(1,4)
		self.powerupsList.append(['oneighty', amount])
		amount = randint(1,4)
		#self.powerupsList.append(['low_grav', amount])
		self.powerupsList.append(['low_grav', 0])
		amount = randint(1,4)
		#self.powerupsList.append(['high_grav', amount])
		self.powerupsList.append(['high_grav', 0])
		amount = randint(1,4)
		#self.powerupsList.append(['delay_view', amount])
		self.powerupsList.append(['delay_view', 0])
		amount = randint(1,4)
		#self.powerupsList.append(['transwarp', amount])
		self.powerupsList.append(['transwarp', 0])
		self.powerupsList.append(['sniper', 0])

		self.loaded = True
		
	def setConfig(self):
		"""
		writes config values to file
		"""
		wFile = open(os.path.expanduser('~/stairs.cfg'), 'w')
		wString = "[keycontrol]\n"
		for i in self.keyList:
			wString += (i[0]+"="+str(i[1])+"\n")
		wString += "[powerups]\n"
		for i in self.powerupsList:
			wString += (i[0]+"="+str(i[1])+"\n")
		wString += "[collecteditems]\n"
		for i in self.collectionList:
			wString += (i+"\n")
		wFile.write(wString)
	
	def setControlKeyValue(self, key, value):
		"""
		fills specific options in category 'keycontrol' with new values
		(dependent on the players orientation)
		
		@type  key: String
		@param key: represents the key in the in the control key section of the config file
		@type  value: Integer
		@param value: the value of the given key
		"""
		
		for i in self.keyList:
			if i[0] == key:
				i[1] = value
		
	def getControlKeyValue(self, key):
	    	"""
		returns the value to the given key in the list of user's input keys
		
		key = String
		@type key: String
		@param key: the key out of the control key section
		@rtype: Integer
		@return: returns the value of the given key
		"""
		
		for i in self.keyList:
			if i[0] == key:
				return i[1]
		return -1
	
	def setPowerUps(self, key, value):
		"""
		fills specific options in category 'powerups' with new values
		(collected player properties)
		
		@type key: String
		@param key: represents the key in the in the powerups section of the config file
		@type value: Integer
		@param value: the value of the the given key
		"""
		
		for i in self.powerupsList:
			if i[0] == key:
				i[1] = value
	
	def getPowerUpValue(self, key):
		"""
		returns the value to the given key in the list of user's powerups
		
		@type key: String
		@param key: the name of the powerup
		
		@rtype: Integer
		@return: returns the number of the given key
		"""
		
		for i in self.powerupsList:
			if i[0] == key:
				return i[1]
		return 0
	
	def setMerch(self, merch_name):
		"""
		fills specific options in category 'collecteditems' with new values
		(collected player merchandise)
		
		@type merch_name: String
		@param merch_name: the name of the merchandise object
		"""
		
		exist = False
		for i in self.collectionList:
			if i == merch_name:
				exist = True
		
		if not exist:
			self.collectionList.append(merch_name)
			



