######## JUST FOR CREATING THE GAME ELEMENTS

import Blender
from Blender import Object, Mesh, Window, Material, Scene, Texture
from Blender.BGL import *
from Blender.Draw import *

import bpy
import time
import random
import math
from math import *

scen = Scene.Get("game")
scen.setLayers([1,2,3,4,5,11,14,15]) # game layers

# Events
EVENT_NOEVENT	= 1
EVENT_DRAW		= 2
EVENT_EXIT		= 3

# Default Element Parameters for GUI
T_StairNum = Create(10)
T_PlatfHeight = Create(1.0)
T_PlatfWidth = Create(4.0)
T_PlatfDepth = Create(4.0)
T_MaxStepNum = Create(20)
T_ObjName = "noname"

StepVerticesBase = [
	[-1, -2], #ltt
	[+1, -2], #rtt
	
	[-1, -1], #lb
	[+1, -1], #rb
	[-1,  0], #lm
	[+1,  0], #rm
	[-1, +1], #lt
	[+1, +1], #rt
]

StepFacesBase = [
	[ 0,  1,  3,  2], #fb
	
	[ 2,  3,  5,  4], #ft
	[ 6,  0,  2,  8], #lb
	[ 8,  2,  4, 10], #lt
	[ 1,  7,  9,  3], #rb
	[ 3,  9, 11,  5], #rt
	[ 4,  5, 11, 10], #top
	[ 6,  7,  1,  0],  #bottom
	[ 7,  6,  8,  9], #bb
	
	[ 9,  8, 10, 11] #bt
]

PlatformVerticesBase = [
	[+1, +1, +1], #rtf
	[+1, +1, -1], #rbf
	[-1, +1, +1], #ltf
	[-1, +1, -1], #lbf
	[+1, -1, +1], #rtb
	[+1, -1, -1], #rbb
	[-1, -1, +1], #ltb
	[-1, -1, -1]  #lbb
]

PlatformFacesBase = [
	[0, 1, 3, 2], #front
	[4, 6, 7, 5], #back
	[0, 4, 5, 1], #right
	[3, 7, 6, 2], #left
	[0, 2, 6, 4], #top	
	[1, 5, 7, 3]  #bottom
]


######## Draw Gui
def draw():
	global T_PlatfHeight
	global T_PlatfWidth
	global T_PlatfDepth
	global T_StairNum
	global T_MaxStepNum
	global EVENT_NOEVENT,EVENT_DRAW,EVENT_EXIT
	
	txt_y_pos = 15
	gap = 25
		
 	Button("Draw",EVENT_DRAW , 10, txt_y_pos, 80, 18)
 	Button("Exit",EVENT_EXIT , 140, txt_y_pos, 80, 18)
	
	txt_y_pos += gap
	
	#T_StairLabel = String("Name:",EVENT_NOEVENT, 10, 205, 210, 18, T_StairLabel.val,20);
	#T_DownStairs = Slider("Downstairs Length:",EVENT_NOEVENT, 230, 205, 210, 18,
	#				 T_DownStairs.val, 0.001, 20.0, 0);

	T_PlatfDepth = Number("Platform depth: ", EVENT_NOEVENT, 10, txt_y_pos, 210, 18,
                     T_PlatfDepth.val, 0.001, 20.0);
	txt_y_pos += gap
	T_PlatfWidth = Number("Platform width: ", EVENT_NOEVENT, 10, txt_y_pos, 210, 18,
                     T_PlatfWidth.val, 0.001, 20.0);
	txt_y_pos += gap
	T_PlatfHeight = Number("Platform height: ", EVENT_NOEVENT, 10, txt_y_pos, 210, 18,
                     T_PlatfHeight.val, 0.001, 20.0);
	txt_y_pos += gap
	
	glClear(GL_COLOR_BUFFER_BIT)		
	glRasterPos2d(10, txt_y_pos)
 	Text("Platform parameters:")
	txt_y_pos += gap
	
	T_MaxStepNum = Number("Max number of steps: ", EVENT_NOEVENT, 10, txt_y_pos, 210, 18,
                     T_MaxStepNum.val, 1, 500);
	txt_y_pos += gap
	T_StairNum = Number("Number of stairs: ", EVENT_NOEVENT, 10, txt_y_pos, 210, 18,
                     T_StairNum.val, 1, 500);
	txt_y_pos += gap
	
 	glRasterPos2d(10, txt_y_pos)
 	Text("Stair parameters:")
	txt_y_pos += gap

	glRasterPos2d(10, txt_y_pos)
	Text("Script for creating game elements")
 

######### Key Event
def event(evt, val):	
 	if (evt == QKEY and not val): 
 		Exit()


######### Button Event 
def bevent(evt):
 	global EVENT_NOEVENT,EVENT_DRAW,EVENT_EXIT
	
	if (evt == EVENT_EXIT): 
		Exit()
 	elif (evt== EVENT_DRAW):
		print "\n\n############### New game elements BEGIN #############\n"

		n = 0
		while(n < T_StairNum.val):
			selObj = Object.GetSelected()
			for object in selObj:
				object.select(0)

			step_num = random.randint(2, T_MaxStepNum.val)
			MakeStair(step_num)
			
			n+=1
		
		MakeStair(1)
		MakePlatform()
		
		Blender.Redraw()
		Window.RedrawAll()
		
		print "\n############### New game elements END ###############\n\n"
 
Register(draw, event, bevent)


######## Stair material
#mat_stair = bpy.data.materials.new("stair")
#mat_stair.rgbCol = [1.0, 0, 0]


######## Platform material
#mat_plat = bpy.data.materials.new("platform")
#mat_plat.rgbCol = [0.8, 0.8, 0.8]


######## Exit editmode
editMode = Window.EditMode()
if editMode: Window.EditMode(0)


######## Make object vertices
def MakeObjectVertices(s_width, s_height, s_depth, step_num):
	stair_vertices	= []
	
	# make vertex list for stair, step by step	
	for num in range(step_num+1):
		step_vertices_list = []
		
		s_posy	= (num * s_depth)
		s_posz	= (num * (s_height / 2))

		if (num == step_num):
			
			step_vertices_list = StepVerticesBase[:6:]	
		elif (num != 0):
			step_vertices_list = StepVerticesBase
		else:
			step_vertices_list = StepVerticesBase[2::]
		
		for vertex in step_vertices_list:
			stair_vertices.append([vertex[0] * (s_width / 2), s_posy, s_posz + (vertex[1] * (s_height / 2))])
	
	return stair_vertices


######## Make object faces
def MakeObjectFaces(step_num):
	stair_faces		= []
	
	# make face list for stair, step by step
	if (step_num == 1):
		stair_faces = StepFacesBase[:]
	else:
		for num in range(step_num):	
			if (num == 0):
				step_faces_list = StepFacesBase[:len(StepFacesBase)-1]
			elif (num == step_num-1):
				step_faces_list = StepFacesBase[1::]
			else:
				step_faces_list = StepFacesBase[1:len(StepFacesBase)-1]
		
			add = num * 8
		
			for faces in step_faces_list:
				stair_faces.append([faces[0] + add, faces[1] + add, faces[2] + add, faces[3] + add]) 
	
	return stair_faces


######## Make level object
def MakeStairObject(s_name, o_width, o_height, o_depth, step_num):
	stairMesh = bpy.data.meshes.new()
	
	stairMesh.verts.extend(MakeObjectVertices(o_width, o_height, o_depth, step_num))
	stairMesh.faces.extend(MakeObjectFaces(step_num))
	
	stairMesh.name = s_name
	
	stairObj = scen.objects.new(stairMesh, stairMesh.name)
	
	return stairObj


######## Set game properties
def SetGameProperties(obj, o_width, o_height, o_depth, step_num):
	obj.addProperty("width", o_width, "FLOAT") 
	obj.addProperty("height", ((o_height/2) * step_num) + (o_height/2), "FLOAT")
	depth = o_depth * step_num
	obj.addProperty("depth", depth, "FLOAT")
	obj.addProperty("id", -1, "INT")
	if obj.name != "platform":
		obj.addProperty("step_height", o_height, "FLOAT")

	obj.rbFlags = obj.rbFlags | Object.RBFlags.ACTOR
	obj.rbShapeBoundType = obj.rbShapeBoundType | Object.RBShapes.POLYHEDERON


######## Make stair
def MakeStair(step_num):
	s_name = T_ObjName
	s_width = T_PlatfWidth.val * 2
	s_height = T_PlatfHeight.val * 2
	s_depth	= random.randint(3,6) * 1.0
		
	up = random.randint(0,1)
	
	if (step_num == 1):
		s_depth = 4.0
		s_name = "single_step"
	else:
		s_name = "stair"
	
	stairObj = MakeStairObject(s_name, s_width, s_height, s_depth, step_num)
	stairObj.select(1)
	stairObj.name = s_name
	
	SetGameProperties(stairObj, s_width, s_height, s_depth, step_num)
	
	MakeMaterial(step_num)
	
	stairObj.select(0)


######### Set Material	
def MakeMaterial(step_num):
	ix = 0
	curObj = Object.GetSelected()
	
	n = curObj[0].getData(False, True)
	n.addUVLayer("UVTex")
	
	if (step_num == 0):
		#mat = Material.Get("rust")
		mat_plat = bpy.data.materials.new("platform")
		mat_plat.rgbCol = [0.8, 0.8, 0.8]
		mat_stair = bpy.data.materials.new("stair")
		mat_stair.rgbCol = [1.0, 0, 0]
		n.materials = [mat_plat, mat_stair]
		
		for i in range(4):
			n.faces[i].mat = 1
		n.faces[4].mat = 0
		n.faces[5].mat = 0
		ix = 6	
	else:
		mat = Material.Get("rust")
		mtextures = mat.getTextures()
		for mtex in mtextures:
			if mtex and mtex.tex.type == Texture.Types.IMAGE:
				mtex.uvlayer = "UVTex"
				#print mtex.tex.image.filename
		
		n.materials = [mat]
		
		if (step_num == 1):
			ix = 7
		else:
			ix = 8
	
	n.update()
	curObj[0].layers = [ix]


######### Make platform
def MakePlatform():
	platform= bpy.data.meshes.new()

	platform.verts.extend(PlatformVerticesBase)
	
	platform.faces.extend(PlatformFacesBase)
	
	platform.name = "platform"
	
	platformObj = scen.objects.new(platform, "platform")
	platformObj.select(1)
	
	SetGameProperties(platformObj, T_PlatfWidth.val * 2, T_PlatfHeight.val * 2, T_PlatfDepth.val * 2, 1)	

	platformObj.SizeX = T_PlatfWidth.val
	platformObj.SizeY = T_PlatfDepth.val
	platformObj.SizeZ = T_PlatfHeight.val

	MakeMaterial(0)
	
	platformObj.select(0)


